'use strict';

/**
 * @author Vadym Gidulian, GVIA Group
 */

const canvas = document.getElementById('game');
var ctx;
const SIZE = canvas.width;
const THICK_BORDER = 10;
const WHITE_BORDER = 3*THICK_BORDER;
const BORDER = THICK_BORDER + WHITE_BORDER;
const SQUARE = (SIZE - 2 * BORDER) / 8;
const PIECE = 0.7 * SQUARE;

const FONT = WHITE_BORDER;
const FONT_WIDTH = 0.6 * FONT;

const COLOR_BORDER_THICK = '#000';
const COLOR_BORDER_THIN = '#000';
const COLOR_LETTERS = '#000';
const COLOR_SQUARE_BLACK = '#000';
const COLOR_SQUARE_WHITE = '#fff';
const COLOR_PIECE_BLACK = '#000';
const COLOR_PIECE_WHITE = '#fff';

init();
drawGameBoard();
drawPieces();

function init() {
    ctx = canvas.getContext('2d');
}

function drawGameBoard() {
    // Borders
    ctx.fillStyle = COLOR_BORDER_THICK;
    ctx.fillRect(0, 0, SIZE, SIZE);
    ctx.clearRect(THICK_BORDER, THICK_BORDER, SIZE - 2*THICK_BORDER, SIZE - 2*THICK_BORDER);
    ctx.fillStyle = COLOR_BORDER_THIN;
    ctx.strokeRect(BORDER, BORDER, SIZE - 2*BORDER, SIZE - 2*BORDER);

    // Squares
    for (var i = 0; i < 8; i++) {
        for (var j = 0; j < 8; j++) {
            if ((i + j) % 2) {
                ctx.fillStyle = COLOR_SQUARE_BLACK;
                ctx.fillRect(BORDER + j*SQUARE, BORDER + i*SQUARE, SQUARE, SQUARE);
            } else {
                ctx.fillStyle = COLOR_SQUARE_WHITE;
                ctx.fillRect(BORDER + j*SQUARE, BORDER + i*SQUARE, SQUARE, SQUARE);
            }
        }
    }

    ctx.font = FONT + 'px serif';
    var letters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H'];
    var numbers = ['1', '2', '3', '4', '5', '6', '7', '8'];
    ctx.fillStyle = COLOR_LETTERS;
    for (i = 0; i < 8; i++) {
        ctx.fillText(letters[i], BORDER+SQUARE/2-FONT_WIDTH/2 + i*SQUARE, BORDER-FONT/6, FONT_WIDTH);
        ctx.fillText(letters[i], BORDER+SQUARE/2-FONT_WIDTH/2 + i*SQUARE, SIZE-THICK_BORDER-FONT/6, FONT_WIDTH);

        ctx.fillText(numbers[7-i], THICK_BORDER+(WHITE_BORDER-FONT_WIDTH)/2, BORDER+SQUARE/2+FONT/2 + i*SQUARE, FONT_WIDTH);
        ctx.fillText(numbers[7-i], SIZE-BORDER+(WHITE_BORDER-FONT_WIDTH)/2, BORDER+SQUARE/2+FONT/2 + i*SQUARE, FONT_WIDTH);
    }
}

function drawPieces() {
    drawPiece('A1', 'black');
    drawPiece('A3', 'black');
    drawPiece('B2', 'black');
    drawPiece('C1', 'black');
    drawPiece('C3', 'black');
    drawPiece('D2', 'black');
    drawPiece('E1', 'black');
    drawPiece('E3', 'black');
    drawPiece('F2', 'black');
    drawPiece('G1', 'black');
    drawPiece('G3', 'black');
    drawPiece('H2', 'black');

    drawPiece('A8', 'white');
    drawPiece('A6', 'white');
    drawPiece('B7', 'white');
    drawPiece('C8', 'white');
    drawPiece('C6', 'white');
    drawPiece('D7', 'white');
    drawPiece('E8', 'white');
    drawPiece('E6', 'white');
    drawPiece('F7', 'white');
    drawPiece('G8', 'white');
    drawPiece('G6', 'white');
    drawPiece('H7', 'white');
}

function drawPiece(position, color, isKing) {
    var col = position.toUpperCase().charCodeAt(0) - 65;
    var row = position.toUpperCase().charCodeAt(1) - 49;

    switch (color) {
        case 'black':
            ctx.fillStyle = COLOR_PIECE_BLACK;
            ctx.strokeStyle = COLOR_PIECE_WHITE;
            break;
        case 'white':
            ctx.fillStyle = COLOR_PIECE_WHITE;
            ctx.strokeStyle = COLOR_PIECE_BLACK;
    }

    ctx.beginPath();
    ctx.arc(BORDER+SQUARE/2 + col*SQUARE, BORDER+SQUARE/2 + (7-row)*SQUARE, PIECE/2, 0, 2*Math.PI);
    ctx.fill();

    ctx.beginPath();
    ctx.arc(BORDER+SQUARE/2 + col*SQUARE, BORDER+SQUARE/2 + (7-row)*SQUARE, PIECE/2, 0, 2*Math.PI);
    ctx.stroke();

    ctx.beginPath();
    ctx.arc(BORDER+SQUARE/2 + col*SQUARE, BORDER+SQUARE/2 + (7-row)*SQUARE, PIECE/3, 0, 2*Math.PI);
    ctx.stroke();

    if (isKing) {
        switch (color) {
            case 'black':
                ctx.fillStyle = COLOR_PIECE_WHITE;
                break;
            case 'white':
                ctx.fillStyle = COLOR_PIECE_BLACK;
        }

        ctx.beginPath();
        ctx.arc(BORDER+SQUARE/2 + col*SQUARE, BORDER+SQUARE/2 + (7-row)*SQUARE, PIECE/10, 0, 2*Math.PI);
        ctx.fill();
    }
}
