'use strict';

/**
 * @author Vadym Gidulian, GVIA Group
 */

const canvas = document.getElementById('game');
var ctx;
const SIZE = canvas.width;
const THICK_BORDER = 10;
const WHITE_BORDER = 3*THICK_BORDER;
const BORDER = THICK_BORDER + WHITE_BORDER;
const SQUARE = (SIZE - 2 * BORDER) / 8;
const FONT = WHITE_BORDER;
const FONT_WIDTH = 0.6 * FONT;

init();
drawGameBoard();

function init() {
    ctx = canvas.getContext('2d');
}

function drawGameBoard() {
    // Borders
    ctx.fillRect(0, 0, SIZE, SIZE);
    ctx.clearRect(THICK_BORDER, THICK_BORDER, SIZE - 2*THICK_BORDER, SIZE - 2*THICK_BORDER);
    ctx.strokeRect(BORDER, BORDER, SIZE - 2*BORDER, SIZE - 2*BORDER);

    // Squares
    for (var i = 0; i < 8; i++) {
        for (var j = 0; j < 8; j++) {
            if ((i + j) % 2) {
                ctx.fillRect(BORDER + j*SQUARE, BORDER + i*SQUARE, SQUARE, SQUARE);
            } else {
                ctx.clearRect(BORDER + j*SQUARE, BORDER + i*SQUARE, SQUARE, SQUARE);
            }
        }
    }

    ctx.font = FONT + 'px serif';
    var letters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H'];
    var numbers = ['1', '2', '3', '4', '5', '6', '7', '8'];
    for (i = 0; i < 8; i++) {
        ctx.fillText(letters[i], BORDER+SQUARE/2-FONT_WIDTH/2 + i*SQUARE, BORDER-FONT/6, FONT_WIDTH);
        ctx.fillText(letters[i], BORDER+SQUARE/2-FONT_WIDTH/2 + i*SQUARE, SIZE-THICK_BORDER-FONT/6, FONT_WIDTH);

        ctx.fillText(numbers[7-i], THICK_BORDER+(WHITE_BORDER-FONT_WIDTH)/2, BORDER+SQUARE/2+FONT/2 + i*SQUARE, FONT_WIDTH);
        ctx.fillText(numbers[7-i], SIZE-BORDER+(WHITE_BORDER-FONT_WIDTH)/2, BORDER+SQUARE/2+FONT/2 + i*SQUARE, FONT_WIDTH);
    }
}
