# vue-test-directive
A Vue directive to help test code and other directives

## Usage

### `.directive`

```js
const TestDirective = require(...);
Vue.directive('test', TestDirective.directive(options));
```

#### Options

- `disabled` (`boolean`) - disable the directive. Set via `directiveValue.disabled` or `options.disabled` (ordered by precedence)
- `hooks` (`object`) - hooks to handle by the directive. Set via `directiveValue.hooks` or modifiers or `options.hooks` (ordered by precedence)
- `label` (`string`) - directive label shown in console. Set via `directiveValue.label` or argument or `options.label` (ordered by precedence)
- `style` (`string`) - styles of console output. Set via `directiveValue.style` or `options.style` (ordered by precedence)

#### Examples

```vue
<div v-test></div>
```
```vue
<div v-test:label></div>
```
```vue
<div v-test.bind.unbind></div>
```
```vue
<div v-test:label.bind.unbind></div>
```
```vue
<div v-test="{
	disabled: true,
	hooks: {bind: true},
	label: 'label',
	style: 'color: #f00'
}"></div>
```

### `.wrap`

```js
const TestDirective = require(...);
Vue.directive('wrapped', TestDirective.wrap(directive, options));
```

#### Options

- `disabled` (`boolean`) - disable the directive. Set via `directiveValue.test.disabled` or `options.disabled` (ordered by precedence)
- `hooks` (`object`) - hooks to handle by the directive. Set via `directiveValue.test.hooks` or modifiers starting with `test:` or `options.hooks` (ordered by precedence)
- `label` (`string`) - directive label shown in console. Set via `directiveValue.test.label` or argument (after `test:` or `:test:`) or `options.label` (ordered by precedence)
- `style` (`string`) - styles of console output. Set via `directiveValue.test.style` or `options.style` (ordered by precedence)

##### Notes
- binding passed to wrapped directive will be filtered from test directive options
- if non-object value should be passed to wrapped directive and it's necessary to use `directiveValue.test.*` options, the value for wrapped directive may be set via `directiveValue.test.value`

#### Examples

```vue
<div v-wrapped></div>
```
```vue
<div v-wrapped="..."></div>
```
```vue
<div v-wrapped:arg:test:label></div>
```
```vue
<div v-wrapped.test:bind.test:unbind></div>
```
```vue
<div v-wrapped:test:label.test:bind.test:unbind></div>
```
```vue
<div v-wrapped="{
	...,
	test: {
		disabled: true,
		hooks: {bind: true},
		label: 'label',
		style: 'color: #f00'
	}
}"></div>
```
```vue
<div v-wrapped="{
	test: {
		disabled: true,
		hooks: {bind: true},
		label: 'label',
		style: 'color: #f00',
		value: ...
	}
}"></div>
```
