# vue-stylize
A Vue directive to watch and change elements' style

## Description

The directive watch for changes of an element and its descendants.

When a change is detected (and at the init) it applies to specified elements corresponding style configs.

***Notes:***

*A change will be detected if `class` or `style` attribute changes.*

*When style configs are applying, watch is disabled.*

## Usage

```js
Vue.directive('stylize', require(...));
```
```vue
<... v-stylize="..."></...>
```

### Config

Config, which is passed via directive value, is an object with query selectors as keys and [style config](#style-config)s as values.

#### Style config

May be one of the following:
- [class names](#class-names)
- an `object` with the following optional keys:
  - `class` - [class names](#class-names)
  - `style` - [style properties](#style-properties)
- a `function` that takes the current element and returns one of the previous types

#### Class names

May be one of the following:
- a `string` with class names separated by whitespace characters
- an `array`, items of which may be one of the following:
  - a `string` containing a class name
  - a `function` that takes the current element and returns a `string`
- a `function` that takes the current element and returns one of the previous types

***Note:*** *If a class name is enclosed in `~` (i.e. `~classname~`), the class name will be removed from the element.*

#### Style properties

May be one of the following:
- an `object` with CSS properties as keys and one of the following as values:
  - a `string` with property value
  - a `function` that takes the current element and returns a `string`
- a `function` that takes the current element and returns an `object`

## Examples

```vue
<... class="a" v-stylize="{'.a': 'x', '.b': 'y ~b~'}">
	<... class="a b">...</...>
</...>
```
will be rendered as
```vue
<... class="a x">
	<... class="a x y">...</...>
</...>
```
