'use strict';

const stringRequiredSchema = {
	type:       String,
	required:   true,
	minLength:  1,
	transforms: [String.prototype.trim]
};

const tokenSchema = {
	type:       String,
	required:   true,
	transforms: [String.prototype.trim]
};

const tokenRuleSchema = {
	type:     Object,
	required: true,
	properties: {
		methods: {
			type:      Array,
			item:      stringRequiredSchema,
			minLength: 1
		},
		paths: {
			type:      Array,
			item:      stringRequiredSchema,
			minLength: 1
		}
	},
	minProperties: 1,
	maxProperties: 2
};

module.exports = {
	type:         Object,
	required:     true,
	propertyName: tokenSchema,
	property: [
		{
			type:     Boolean,
			required: true
		},
		tokenRuleSchema,
		{
			type:      Array,
			required:  true,
			item:      tokenRuleSchema,
			minLength: 1
		}
	]
};
