# token-based-authz-middleware

An Express middleware for token-based authorization.

## Usage

```js
app.use(authzMiddleware(options))
```

### Options

- `headerName` `[string]` Default: `X-Token`
    
    Header name used to pass a token.

- `pathToRules` `[string]`
    
    Path to file containing tokens and rules associated with them.

### Rules

Rules are a JSON file containing a single object with tokens as keys and rules associated with them as values.

```
{
    "token1": <tokenRules>,
    "token2": <tokenRules>,
    ...
}
```

`<tokenRules>` may be one of the following:
- `boolean` - if `true` access is allowed, denied otherwise.
- `<tokenRule>` - an object, which may contain the following properties:
    - `methods` - an array of allowed HTTP methods
    - `paths` - an array of paths access to which is allowed. Path is a `RegExp` string.
    
    _At least one property must be specified._
- `Array` - an array of `<tokenRule>`s. The resulting rule is a union of listed rules.

Tokens specified in rules are trimmed. Spaces around tokens should be avoided because it may lead to ambiguous behavior.

Empty string may be used to define rules for requests w/o token or w/ empty one.

#### Example

```json
{
    "token1": false,
    "token2": true,
    "token3": {
        "methods": ["get"]
    },
    "token4": {
        "paths": ["^/admin"]
    },
    "token5": [
        {
            "methods": ["get"]
        }, {
            "methods": ["post"],
            "paths":   ["comment"]
        }
    ],
    "": {
        "methods": ["get"]
    }
}
```

- `token1` - All requests will be blocked.
- `token2` - All requests will pass.
- `token3` - Only `GET` requests will pass.
- `token4` - All requests to paths beginning with `admin` will pass.
- `token5` - Only `GET` requests or `POST` requests to paths containing `comment` will pass.
- All `GET` requests w/o token or w/ empty one will pass.
