'use strict';

const express = require('express');

const app = express()
	.use(require('../../src/apis')())
	.use((req, res) => {
		console.warn(`${req.url} was not handled`);
		res.status(404).set('Content-Type', 'text/plain').send(`${req.url} was not handled`);
	})
	.use((err, req, res, next) => {
		console.error(err);
		if (!res.finished) res.status(500).set('Content-Type', 'text/plain').send(err.stack);
	});

let server;

module.exports = {
	
	start() {
		return new Promise(resolve => {
			server = app.listen(80, () => {
				console.info('Server is started.');
				resolve();
			});
		});
	},
	
	stop() {
		return new Promise((resolve, reject) => {
			server.close(err => {
				if (err) {
					console.error('Can\'t stop the server');
					return reject(err);
				}
				
				console.info('Server is stopped');
				resolve();
			});
		});
	}
	
};
