'use strict';

class AppError extends Error {
	
	constructor(message, code = 500, cause) {
		super(message);
		
		if (Error.captureStackTrace) {
			Error.captureStackTrace(this, AppError);
		}
		
		this.name  = this.constructor.name;
		this.code  = code;
		this.cause = cause;
	}
	
}

module.exports = {
	AppError
};
