'use strict';

const {pick} = require('../utils/util');

const dateSchema     = require('./primitives/date');
const fileNameSchema = require('./primitives/file-name');
const versionSchema  = require('./primitives/version');

module.exports = [
	{
		type:     Object,
		required: true,
		properties: {
			version:     versionSchema,
			publishDate: dateSchema,
			fileName:    fileNameSchema,
			fileSize: {
				type:     Number,
				required: true,
				min:      0
			},
			private: {
				type: [true]
			}
		},
		transformsAfter: [
			pick('version', 'publishDate', 'fileName', 'fileSize', 'private')
		]
	}, {
		type:     null,
		required: true
	}
];
