# release-server-middleware

An Express middleware for release server.

## Description

Release server only works with [Semantic Versioning (SemVer)](https://semver.org/).

Releases may be marked as private.

The latest release is a release with the greatest version among non-private releases.

## Usage

```js
app.use(releaseServerMiddleware(options))
```

### Options

- `filesDir` `[string]` Default: `/files`
    
    Path to directory used to store releases.

- `tmpFilesDir` `[string]` Default: `<filesDir>/.tmp`
    
    Path to directory used to store temp files.

### API

- Download the latest release
    ```
    GET /latest
    ```
- Get the latest release's info
    ```
    GET /latest/info
    ```
- Download specific release
    ```
    GET /:version
    ```
- Get specific release's info
    ```
    GET /:version/info
    ```
- Get all releases' info
    ```
    GET /releases
    ```
- Upload a release
    ```
    PUT /:version
    Content-Type: multipart/form-data
    [X-File-Name: file.ext]
    [X-Private]
    
    file=...
    ```
    
    `X-File-Name` - an optional header to set new file name.
    
    `X-Private` - an optional header to mark release as private.
- Delete a release
    ```
    DELETE /:version
    ```
