const gulp      = require('gulp');
const babel     = require('gulp-babel');
const uglify    = require('gulp-uglify');

const paths = new function() {
	this.srcDir  = 'src';
	this.distDir = 'dist';
	
	this.js    = this.srcDir + '/index.js';
	this.jsOut = this.distDir;
};

// Scripts

gulp.task('js', function () {
	return gulp.src(paths.js)
		.pipe(babel({
			presets: ['env']
		}))
		.pipe(uglify({
			compress: true,
			mangle: {
				toplevel: true
			}
		}))
		.pipe(gulp.dest(paths.jsOut));
});

// Stages

gulp.task('watch', function () {
	gulp.watch(paths.js, gulp.task('js'));
});

gulp.task('build', gulp.task('js'));

gulp.task('default', gulp.task('build'));
