const test = require('ava');

const PV = require('../dist/index');

test.cb('Promised value', t => {
	t.plan(6);
	
	const v = new PV(42);
	v.willBeReady.then(value => {
		t.is(value, 123);
	});
	
	t.is(v.isReady, false);
	t.is(v.value, 42);
	
	v.value = 123;
	
	t.is(v.isReady, true);
	t.is(v.value, 123);
	
	v.willBeReady.then(value => {
		t.is(value, 123);
		t.end();
	});
});

test('Use new only', t => {
	try {
		PV();
		t.fail('An exception should be thrown');
	} catch (e) {
		t.pass();
	}
});
