'use strict';

module.exports = PromisedValue;

function PromisedValue(initialValue) {
	if (!(this instanceof PromisedValue)) {
		throw new TypeError("Cannot call a class as a function");
	}
	
	let initialized    = false;
	let value          = initialValue;
	
	let resolvePromise;
	let willBeReady = new Promise(resolve => {
		resolvePromise = resolve;
	});
	
	Object.defineProperties(this, {
		isReady: {
			get() {
				return initialized;
			}
		},
		value: {
			get() {
				return value;
			},
			set(newValue) {
				value = newValue;
				
				if (!initialized) {
					resolvePromise(value);
					initialized = true;
				} else {
					willBeReady = Promise.resolve(value);
				}
			}
		},
		willBeReady: {
			get() {
				return willBeReady;
			}
		}
	});
}
