const test = require('ava');

const PV = require('../dist/index');

test.cb('Promised value', t => {
	t.plan(8);
	
	const v = new PV(42);
	v.willBeReady.then(value => {
		t.is(v.isReady, true);
		t.is(value, 123);
	});
	
	t.is(v.isReady, false);
	t.is(v.value, 42);
	
	v.value = 123;
	
	t.is(v.isReady, true);
	t.is(v.value, 123);
	
	v.willBeReady.then(value => {
		t.is(v.isReady, true);
		t.is(value, 123);
		t.end();
	});
});

test('Use new only', t => {
	try {
		PV();
		t.fail('An exception should be thrown');
	} catch (e) {
		t.pass();
	}
});

test('Property descriptors', t => {
	const v = new PV(42);
	
	t.true(Object.keys(v).toString() === ['isReady', 'value', 'willBeReady'].toString());
	
	Object.defineProperty(v, 'value', {
		value: 42,
		writable: false
	});
	t.is(v.value, 42);
	try {
		v.value = 43;
		t.fail('An exception should be thrown');
	} catch (e) {
		t.pass();
	}
	
	delete v.value;
	t.false(v.hasOwnProperty('value'));
	t.true(Object.keys(v).toString() === ['isReady', 'willBeReady'].toString());
});

test.cb('isReady descriptor', t => {
	t.plan(15);
	
	const v = new PV(42);
	
	let descriptor = Object.getOwnPropertyDescriptor(v, 'isReady');
	t.true(descriptor.configurable);
	
	Object.defineProperty(v, 'isReady', {
		configurable: true,
		enumerable:   true,
		get() { // 4 times
			t.pass();
			return descriptor.get.call(v);
		},
		set(newValue) { // 1 time
			t.false(descriptor.get.call(v));
			t.true(newValue);
		}
	});
	
	
	v.willBeReady.then(value => {
		t.is(v.isReady, true);
		t.is(value, 123);
	});
	
	t.is(v.isReady, false);
	t.is(v.value, 42);
	
	v.value = 123;
	
	t.is(v.isReady, true);
	t.is(v.value, 123);
	
	v.willBeReady.then(value => {
		t.is(v.isReady, true);
		t.is(value, 123);
		t.end();
	});
	
});
