'use strict';

module.exports = PromisedValue;

function PromisedValue(initialValue) {
	if (!(this instanceof PromisedValue)) {
		throw new TypeError("Cannot call a class as a function");
	}
	
	let initialized = false;
	let value       = initialValue;
	
	let resolvePromise;
	let willBeReady = new Promise(resolve => {
		resolvePromise = resolve;
	});
	
	Object.defineProperties(this, {
		isReady: {
			configurable: true,
			enumerable:   true,
			get() {
				return initialized;
			}
		},
		value: {
			configurable: true,
			enumerable:   true,
			get() {
				return value;
			},
			set(newValue) {
				value = newValue;
				
				if (!initialized) {
					try {
						this.isReady = true; // in case of defined setter
					} catch (e) {/*ignore*/}
					initialized = true;
					
					resolvePromise(value);
				} else {
					willBeReady = Promise.resolve(value);
				}
			}
		},
		willBeReady: {
			enumerable: true,
			get() {
				return willBeReady;
			}
		}
	});
}
