# objb

A binary representation of obj file format.

## Usage

### `objToObjb(source[, options])`

Converts obj file to objb.

- `source` `string`
    
    Obj file content.
    
- `options`
    - `useFloat16` `[boolean]` Default: `false`
        
        Use `float16` instead of `float32`. May result in decreased model accuracy.

Returns `ArrayBuffer` with objb file content.

### `objbToObj(buffer)`

Converts objb file to obj.

- `buffer` `ArrayBuffer`
    
    Objb file content.

Returns `string` with obj file content.

## File format

- Header: 8 bytes
    - Version: 2 bytes
        - Major: `uint8`
        - Minor: `uint8`
    - Options: 6 bytes
        - useFloat16: 0<sup>th</sup> bit of 0<sup>th</sup> byte
- Body
    - &lt;Section&gt;*

#### Section

- Keyword: `uint8`
    
    One of `v (0x1)`, `vn (0x2)`, `vt (0x3)`, `g (0x4)`, `o (0x5)`, `s (0x6)`, `f (0x7)`.
- Length: `uint32 (BE)`
    
    Length of the section data.
- Data:
    
    One of the following depending on the keyword:
    - `v`: 3 &times; (`float32`/`float16`)
        
        Section data length is a number of geometric vertices.
    - `vt`: 3 &times; (`float32`/`float16`)
        
        Section data length is a number of texture vertices.
    - `vn`: 3 &times; (`float32`/`float16`)
        
        Section data length is a number of vertex normals.
    - `g`: &lt;string&gt;?
        
        Section data length is a string length.
    - `o`: &lt;string&gt;?
        
        Section data length is a string length.
    - `s`: &lt;string&gt;?
        
        Section data length is a string length.
    - `f`:
        
        Section data length is a number of faces.
        
        - `L`: `uint8`
            
            Number of vertices in the face.
        - `bits`: `uint8`
            
            Number of bits used to reference vertex data (`8`, `16` or `32`). 
        - Data: `L` &times; (3 &times; `uint[bits]`)
            
            `0` means that the reference is omitted.

#### String

- Data: `L` &times; `uint16`,
    
    where `L` is a string length.
