var proxy = require('http-proxy-middleware');

var _proxy = proxy('/', {
	target: 'http://localhost:2999',
	changeOrigin: true
});

module.exports = {
	files: [
		'./dist/**/*.{css,html,htm,js,php}'
	],
	reloadDebounce: 500,
	server: {
		baseDir: 'dist',
		middleware: {
			10: _proxy
		}
	},
	watchOptions: {
		ignored: ['./**/*', '!./dist/**/*']
	}
};
