'use strict';

module.exports = {
	
	createError(message, code, cause) {
		const e = new Error(message);
		
		if (code)  e.code  = code;
		if (cause) e.cause = cause;
		
		return e;
	},
	
	log() {
		console.log(`[${getCurrentDateString()}]`, ...arguments);
	},
	logDebug() {
		console.debug(`[${getCurrentDateString()}][🔹DEBUG]`, ...arguments);
	},
	logError() {
		console.error(`[${getCurrentDateString()}][‼️ ERROR]`, ...arguments);
	},
	logInfo() {
		console.info(`[${getCurrentDateString()}][ℹ️ INFO]`, ...arguments);
	},
	logWarn() {
		console.warn(`[${getCurrentDateString()}][⚠️ WARN]`, ...arguments);
	}
	
};

function getCurrentDateString() {
	return new Date().toISOString();
}
