'use strict';

const grace                                     = require('./grace');
const {createError, logError, logInfo, logWarn} = require('./log');

['MONGODB_URI', 'SEQID_GEN_API'].forEach(varname => {
	if (!process.env[varname]) {
		logError(`Environment variable ${varname} is not defined!`);
		grace.shutdown(1);
	}
});

const {MongoClient} = require('mongodb');
const SeqidGenApi   = require('@gviagroup/seqid-gen-api');

let   mongoClient = null;
const seqidGen    = new SeqidGenApi(process.env.SEQID_GEN_API);

grace.registerShutdownHandler(async () => {
	if (mongoClient) await mongoClient.close();
}, {description: 'Closing MongoDB connection'});

module.exports = {
	
	async getConnection() {
		if (!mongoClient) {
			logInfo('Connecting to MongoDB...');
			await connectToMongo();
			if (!mongoClient) return void grace.shutdown(2);
		}
		
		if (!mongoClient.isConnected()) {
			throw createError('MongoDB client is not connected', 500);
		}
		
		return mongoClient;
	},
	
	isConnected() {
		return mongoClient ? mongoClient.isConnected() : false;
	},
	
	seqidGen
	
};

async function connectToMongo() {
	try {
		mongoClient = await MongoClient.connect(process.env.MONGODB_URI, {useNewUrlParser: true});
		mongoClient.on('close',     () => logWarn('MongoDb client\'s connection was closed'));
		mongoClient.on('reconnect', () => logWarn('MongoDB client was reconnected'));
		logInfo('Connected.');
	} catch (e) {
		logError(e);
	}
}
