'use strict';

const {shutdown} = require('./grace');
const {logError} = require('./log');

module.exports = {
	
	checkEnvironmentVariables(...varNames) {
		for (const varName of varNames) {
			if (!process.env[varName]) {
				logError(`Environment variable ${varName} is not set!`);
				shutdown(1);
			}
		}
	}
	
};
