var gulp    = require('gulp');
var less    = require('gulp-less');
var nano    = require('gulp-cssnano');
var uglify  = require('gulp-uglify');
var rename  = require('gulp-rename');
var concat  = require('gulp-concat');
var replace = require('gulp-html-replace');
var htmlMin = require('gulp-htmlmin');
var del     = require('del');

var failSafe = false;

function shallow(done) {
    return function (error) {
        done(error);
    };
}

var paths = new function() {
    this.htmlDir = '.';
    this.html = this.htmlDir + '/*.html';
    this.htmlOut = this.htmlDir;

    this.cssDir = 'css';
    this.css = [
        this.cssDir + '/**/*.css',
        '!' + this.cssDir + '/**/*.min.css',
        '!' + this.cssDir + '/**/font-*.css'
    ];
    this.cssOut = this.cssDir;

    this.jsDir =  'js';
    this.js = [
        this.jsDir + '/**/*.js',
        '!' + this.jsDir + '/**/*.min.js'
    ];
    this.jsOut = this.jsDir;

    this.lessDir = 'less';
    this.less = [
        this.lessDir + '/**/*.less'
    ];
    this.lessOut = this.lessDir;
};

gulp.task('compile-less', function (done) {
    return gulp.src(paths.less)
        .pipe(less().on(failSafe ? 'error' : 'none', shallow(done)))
        .pipe(nano().on(failSafe ? 'error' : 'none', shallow(done)))
        .pipe(rename({
            suffix: '.min'
        }))
        .pipe(gulp.dest(paths.lessOut));
});
gulp.task('min-css', function (done) {
    return gulp.src(paths.css)
        .pipe(nano().on(failSafe ? 'error' : 'none', shallow(done)))
        .pipe(rename({
            suffix: '.min'
        }))
        .pipe(gulp.dest(paths.cssOut));
});
gulp.task('concat-css', ['compile-less', 'min-css'], function () {
    return gulp.src([/* list of files to concat (ex.: [paths.cssOut+'/style.min.css', paths.lessOut+'/style.min.css', ...]) */])
        .pipe(concat('style.all.min.css'))
        .pipe(gulp.dest(paths.cssOut));
});

gulp.task('min-js', function (done) {
    return gulp.src(paths.js)
        .pipe(uglify().on(failSafe ? 'error' : 'none', shallow(done)))
        .pipe(rename({
            suffix: '.min'
        }))
        .pipe(gulp.dest(paths.jsOut));
});
gulp.task('concat-js', ['min-js'], function () {
    return gulp.src([/* list of files to concat (ex.: [paths.jsOut+'/script.min.js', ...]) */])
        .pipe(concat('script.all.min.js'))
        .pipe(gulp.dest(paths.jsOut));
});

gulp.task('html-replace', function () {
    return gulp.src(paths.html)
        .pipe(replace({
            'css': paths.cssOut + '/style.all.min.css',
            'js':  paths.jsOut + '/script.all.min.js'
        }))
        .pipe(gulp.dest(paths.htmlOut))
});
gulp.task('min-html', ['html-replace'], function () {
    return gulp.src(paths.html)
        .pipe(htmlMin({
            collapseWhitespace: true,
            conservativeCollapse: true
        }))
        .pipe(gulp.dest(paths.htmlOut));
});

gulp.task('test', ['concat-css', 'concat-js']);

gulp.task('watch', function () {
    failSafe = true;
    gulp.watch([paths.css, paths.less], ['concat-css']);
    gulp.watch(paths.js, ['concat-js']);
});

gulp.task('build', ['concat-css', 'concat-js', 'min-html']);

gulp.task('clean', ['build'], function () {
    return del([
        paths.cssDir,
        paths.cssOut + '/**/*.css',
        '!' + paths.cssOut,
        '!' + paths.cssOut + '/style.all.min.css',

        paths.jsDir,
        paths.jsOut + '/**/*.js',
        '!' + paths.jsOut,
        '!' + paths.jsOut + '/script.all.min.js',

        paths.lessDir,
        paths.lessOut
    ]);
});

gulp.task('default', ['clean']);
