'use strict';

const _consoleLog   = console.log;
const _consoleDebug = console.debug;
const _consoleError = console.error;
const _consoleInfo  = console.info;
const _consoleWarn  = console.warn;

console.log = function () {
	_consoleLog(`[${getCurrentDateString()}]`, ...arguments);
};
console.debug = function () {
	_consoleDebug(`[${getCurrentDateString()}][🔹DEBUG]`, ...arguments);
};
console.error = function () {
	_consoleError(`[${getCurrentDateString()}][‼️ ERROR]`, ...arguments);
};
console.info = function () {
	_consoleInfo(`[${getCurrentDateString()}][ℹ️ INFO]`, ...arguments);
};
console.warn = function () {
	_consoleWarn(`[${getCurrentDateString()}][⚠️ WARN]`, ...arguments);
};



function getCurrentDateString() {
	return new Date().toISOString();
}
