'use strict';

const {Router}                   = require('express');
const {handle, methodNotAllowed} = require('../utils/api');

const router = module.exports = Router();
const methodNotAllowedHandler = methodNotAllowed(router);

router.route('/')
	.get(handle(undefined, () => ({
		isAlive:      true,
		dependencies: {},
		modules:      {}
	})))
	.all(methodNotAllowedHandler);
