'use strict';

require('./utils/logging');

const express      = require('express');
const responseTime = require('response-time');
const grace        = require('./utils/grace');

const NODE_ENV          = process.env.NODE_ENV || 'development';
const CORS_ALLOW_ORIGIN = process.env.CORS_ALLOW_ORIGIN || '*';

console.info(`Running in ${NODE_ENV} environment`);

const app = express();

app.use(express.json({
	limit: 0
}));
app.use((req, res, next) => {
	res.header('Access-Control-Allow-Origin',   CORS_ALLOW_ORIGIN);
	res.header('Access-Control-Allow-Headers',  'Origin, X-Requested-With, Accept, Content-Type, X-Token, X-File-Name, X-Private');
	res.header('Access-Control-Allow-Methods',  'OPTIONS, HEAD, GET, PUT, DELETE');
	res.header('Access-Control-Expose-Headers', 'Content-Length');
	
	if (req.method === 'OPTIONS') return res.status(204).send();
	
	next();
});
app.use(responseTime());

app.use(require('./apis/index'));
switch (NODE_ENV) {
	case 'production':
		app.use((req, res) => res.status(404).send());
		app.use((err, req, res, next) => {
			console.error(err);
			if (!res.finished) res.status(500).send();
		});
		
		break;
	default:
		app.use((req, res) => {
			console.warn(`${req.url} was not handled`);
			res.status(404).set('Content-Type', 'text/plain').send(`${req.url} was not handled`);
		});
		app.use((err, req, res, next) => {
			console.error(err);
			if (!res.finished) res.status(500).set('Content-Type', 'text/plain').send(err.stack);
		});
}

const server = app.listen(80, () => {
	console.info('Server is started.');
});
grace.registerShutdownHandler(() => new Promise((resolve, reject) => server.close(err => err ? reject(err) : resolve())),
	{description: 'Closing server connections'});
