'use strict';

const express     = require('express');
const jsvv        = require('@gviagroup/jsvv');
const mailerModel = require('./models/mailer');

const requestSchema      = require('./schemas/request');
const templateNameSchema = require('./schemas/template-name');

const CORS_ALLOW_ORIGIN = process.env.CORS_ALLOW_ORIGIN || '*';

const app = express();

app.use(express.json({
	limit: '1mb'
}));
app.use((req, res, next) => {
	res.header('Access-Control-Allow-Origin', CORS_ALLOW_ORIGIN);
	res.header('Access-Control-Allow-Headers', 'Origin, X-Requested-With, Content-Type, Accept');
	res.header('Access-Control-Allow-Methods', 'OPTIONS, POST');
	next();
});

app.post('/:template', async (req, res) => {
	try {
		req.params.template = jsvv(req.params.template, templateNameSchema);
		req.body            = jsvv(req.body,            requestSchema);
	} catch (e) {
		return res.status(400).send(e.message);
	}
	
	try {
		res.status(200).send(await mailerModel.sendMessage(req.params.template, req.body));
	} catch (e) {
		console.error(e);
		res.status(500).send();
	}
	
});

app.listen(80, () => {
	console.log('Server is started.');
});
