'use strict';

['SMTP_HOST', 'SMTP_PORT', 'SMTP_USER', 'SMTP_PASSWORD'].forEach(varname => {
	if (!process.env[varname]) {
		console.error(`Environment variable ${varname} is not defined!`);
		process.exit(1);
	}
});

const {promisify}    = require('util');
const nodemailer     = require('nodemailer');
const templatesModel = require('./templates');

const SMTP_HOST         = process.env.SMTP_HOST;
const SMTP_PORT         = process.env.SMTP_PORT;
const SMTP_SECURE       = process.env.SMTP_SECURE || false;
const SMTP_USER         = process.env.SMTP_USER;
const SMTP_PASSWORD     = process.env.SMTP_PASSWORD;
const SMTP_SENDER       = process.env.SMTP_SENDER || SMTP_USER;

templatesModel.prepareTemplates();

const transporter = nodemailer.createTransport({
	host:   SMTP_HOST,
	port:   SMTP_PORT,
	secure: SMTP_SECURE,
	auth: {
		user: SMTP_USER,
		pass: SMTP_PASSWORD
	},
	pool: true
});
transporter.verify((err) => {
	if (err) {
		console.error(err);
		process.exit(1);
	}
	console.log('SMTP server is ready.');
});
const sendMail = promisify(transporter.sendMail).bind(transporter);

module.exports = {
	async sendMessage(template, request) {
		const message = templatesModel.getTemplate(template).replace(/{{(.+?)}}/g, (match, name) => request.vars && request.vars[name] || '');
		
		const mailer = {
			from:    SMTP_SENDER,
			to:      request.to,
			subject: request.subject,
			html:    message
		};
		
		const {messageId, accepted, rejected} = await sendMail(mailer);
		
		return {messageId, accepted, rejected};
	}
};
