# Mailer
Mailer service for sending templated emails.

## Usage

1. Pull Docker image:
    ```bash
    docker pull registry.git.gvia.group/microservices/mailer
    ```

2. Run container:
    ```bash
    docker run \
        -v $PWD/templates:/app/templates:ro \
        -e SMTP_HOST=example.com \
        -e SMTP_PORT=465 \
        -e SMTP_SECURE=true \
        -e SMTP_USER=mail@example.com \
        -e SMTP_PASSWORD=password \
        registry.git.gvia.group/microservices/mailer
    ```
    or use Docker Compose:
    ```yaml
    version: '3'
    
    services:
      mailer:
        image: registry.git.gvia.group/microservices/mailer
        environment:
          SMTP_HOST: example.com
          SMTP_PORT: 465
          SMTP_SECURE: true
          SMTP_USER: mail@example.com
          SMTP_PASSWORD: password
        volumes:
          - ./templates:/app/templates:ro
    ```

### Environment variables

- `CORS_ALLOW_ORIGIN`: Value of `Access-Control-Allow-Origin` header. Default: `*`
- `SMTP_HOST`: SMTP server's host
- `SMTP_PORT`: SMTP server's port
- `SMTP_SECURE`: If truthy the connection will use TLS when connecting to server.
  If falsy (the default) then TLS is used if server supports the STARTTLS extension.
  In most cases set this value to true if you are connecting to port 465. For port 587 or 25 keep it false
- `SMTP_USER`: Username
- `SMTP_PASSWORD`: Password
- `SMTP_SENDER`: Sender's email address. Default: `SMTP_USER`

### Templates

Templates are located in `/app/templates` directory. Supported template engines are:
- [EJS](https://github.com/mde/ejs) (`.ejs` files)
- [Handlebars](https://github.com/wycats/handlebars.js) (`.hbs` or `.handlebars` files)
- [Pug](https://github.com/pugjs/pug) (`.pug` files)
- Plain text (all other files with or without extension)

In template engines which support includes root for absolute paths is set to `/app/templates`.
I.e. `/includes/header` will be resolved as `/app/templates/includes/header`.

### API

[Swagger](https://generator.swagger.io?url=https%3A%2F%2Fgit.gvia.group%2Fmicroservices%2Fmailer%2Fraw%2Fmaster%2Fopenapi.yaml)
