'use strict';

const express        = require('express');
const responseTime   = require('response-time');
const jsvv           = require('@gviagroup/jsvv');
const mailerModel    = require('./models/mailer');
const templatesModel = require('./models/templates');

const requestSchema      = require('./schemas/request');
const templateNameSchema = require('./schemas/template-name');

const CORS_ALLOW_ORIGIN = process.env.CORS_ALLOW_ORIGIN || '*';

const app = express();

app.use(express.json({
	limit: '1mb'
}));
app.use((req, res, next) => {
	res.header('Access-Control-Allow-Origin', CORS_ALLOW_ORIGIN);
	res.header('Access-Control-Allow-Headers', 'Origin, X-Requested-With, Content-Type, Accept');
	res.header('Access-Control-Allow-Methods', 'OPTIONS, POST');
	next();
});
app.use(responseTime());

app.post('/*', async (req, res) => {
	let templateName = req.url.slice(1);
	
	try {
		templateName = jsvv(templateName, templateNameSchema, {root: 'Template name'});
		req.body     = jsvv(req.body,     requestSchema,      {root: 'requestBody'});
	} catch (e) {
		return res.status(400).send(e.message);
	}
	
	if (!templatesModel.isTemplateExists(templateName)) return res.status(404).send();
	
	try {
		res.status(200).send(await mailerModel.sendMessage(templateName, req.body));
	} catch (e) {
		console.error(e);
		res.status(500).send();
	}
	
});

app.listen(80, () => {
	console.log('Server is started.');
});
