'use strict';

const fs         = require('fs');
const ejs        = require('ejs');
const glob       = require('glob');
const handlebars = require('handlebars');

const TEMPLATES_DIR = '/app/templates';

const TEMPLATES = new Map();

module.exports = {
	
	prepareTemplates() {
		try {
			if (fs.statSync(TEMPLATES_DIR)) {
				const filenames = glob.sync('**/*', {cwd: TEMPLATES_DIR, nodir: true});
				filenames.forEach(filename => {
					TEMPLATES.set(filename, fs.readFileSync(`${TEMPLATES_DIR}/${filename}`, {encoding: 'utf-8'}));
				});
			}
			console.log(`Loaded templates: ${[...TEMPLATES.keys()].map(name => `"${name}"`).join(', ')}`);
		} catch (e) {
			console.error(e);
			process.exit(1);
		}
	},
	
	isTemplateExists(name) {
		return TEMPLATES.has(name);
	},
	
	compile(templateName, vars) {
		const [, ext]  = templateName.split('.');
		const template = TEMPLATES.get(templateName) || '';
		
		switch (ext) {
			case 'ejs':
				return ejs.render(template, vars, {filename: `${TEMPLATES_DIR}/${templateName}`});
			case 'hbs':
			case 'handlebars':
				return handlebars.compile(template)(vars);
			default:
				return template;
		}
	}
	
};
