'use strict';

const fs = require('fs');

const TEMPLATES_DIR = '/app/templates';

const templates = {};

module.exports = {
	prepareTemplates() {
		try {
			if (fs.statSync(TEMPLATES_DIR)) {
				const filenames = fs.readdirSync(TEMPLATES_DIR);
				filenames.forEach(filename => {
					templates[filename] = fs.readFileSync(`${TEMPLATES_DIR}/${filename}`, {encoding: 'utf-8'});
				});
			}
			
			console.log(`Loaded templates: ${Object.keys(templates).map(name => `"${name}"`).join(', ')}`);
		} catch (e) {
			console.error(e);
			process.exit(1);
		}
	},
	
	getTemplate(name) {
		return templates[name] || '';
	}
};
