# PHP
## Basics

Vadym Gidulian <br> GVIA Group


#HSLIDE

## Intro


#VSLIDE

### What is PHP?

> PHP is a popular general-purpose scripting language that is especially suited to web development for making dynamic and interactive Web pages.
>
> Fast, flexible and pragmatic, PHP powers everything from your blog to the most popular websites in the world.


#VSLIDE

* PHP is an acronym for "PHP: Hypertext Preprocessor"
* PHP is a widely-used, open source scripting language
* PHP scripts are executed on the server
* PHP is free to download and use


#VSLIDE

### What is a PHP File?

* PHP files can contain text, HTML, CSS, JavaScript, and PHP code
* PHP code are executed on the server, and the result is returned to the browser as plain HTML
* PHP files have extension `.php`


#VSLIDE

### What Can PHP Do?

* PHP can generate dynamic page content
* PHP can create, open, read, write, delete, and close files on the server
* PHP can collect form data
* PHP can send and receive cookies
* PHP can add, delete, modify data in your database
* PHP can be used to control user access rights
* PHP can encrypt data

With PHP you are not limited to output HTML. You can output images, PDF files, and even Flash movies. You can also output any text, such as XHTML and XML.


#VSLIDE

### Why PHP?

* PHP runs on various platforms (Windows, Linux, Unix, Mac OS X, etc.)
* PHP is compatible with almost all servers used today (Apache, Nginx, IIS, etc.)
* PHP supports a wide range of databases
* PHP is free. Download it from the official PHP resource: [www.php.net](http://www.php.net)
* PHP is easy to learn and runs efficiently on the server side


#HSLIDE

## Syntax

A PHP script can be placed anywhere in the document.

A PHP script starts with `<?php` and ends with `?>`


#VSLIDE

```php
<?php
    // PHP code goes here
?>
```

A PHP file normally contains HTML tags, and some PHP scripting code.


#VSLIDE

```php
<!DOCTYPE html>
<html>
<body>

<h1>My first PHP page</h1>

<?php
    echo "Hello World!";
?>

</body>
</html>
```
_**Note:** PHP statements end with a semicolon (`;`)._


#VSLIDE

### Comments

```php
<!DOCTYPE html>
<html>
<body>

<?php
    // This is a single-line comment

    # This is also a single-line comment

    /*
    This is a multiple-lines comment block
    that spans over multiple
    lines
    */

    // You can also use comments to leave out parts of a code line
    $x = 5 /* + 15 */ + 5;
    echo $x;
?>

</body>
</html>
```


#VSLIDE

### Case Sensitivity

In PHP, all keywords (e.g. `if`, `else`, `while`, `echo`, etc.), classes, functions, and user-defined functions are **NOT** case-sensitive.

```php
<!DOCTYPE html>
<html>
<body>

<?php
    ECHO "Hello World!<br>";
    echo "Hello World!<br>";
    EcHo "Hello World!<br>";
?>

</body>
</html>
```


#VSLIDE

_**Note:** All variables names **ARE** case-sensitive._

```php
<!DOCTYPE html>
<html>
<body>

<?php
    $color = "red";
    echo "My car is " . $color . "<br>";
    echo "My house is " . $COLOR . "<br>";
    echo "My boat is " . $coLOR . "<br>";
?>

</body>
</html>
```


#HSLIDE

## Variables

Variables are "containers" for storing information.


#VSLIDE

### Creating (Declaring) PHP Variables

```php
<?php
    $txt = "Hello world!";
    $x = 5;
    $y = 10.5;
?>
```


#VSLIDE

### Rules

* A variable starts with the `$` sign, followed by the name of the variable
* A variable name must start with a letter or the underscore character
* A variable name **cannot** start with a number
* A variable name can only contain alpha-numeric characters and underscores (A-z, 0-9, and _ )
* Variable names are case-sensitive ($age and $AGE are two different variables)


#VSLIDE

### Typing

PHP is a loosely typed language

PHP automatically converts the variable to the correct data type, depending on its value.


#VSLIDE

### Scope

In PHP, variables can be declared anywhere in the script.

The scope of a variable is the part of the script where the variable can be referenced/used.

PHP has three different variable scopes:
* local
* global
* static


#VSLIDE

### Global and Local Scopes

A variable declared **outside** a function has a **global** scope and can only be accessed outside a function:

```php
<?php
    $x = 5; // global scope
    
    function myTest() {
        // using `x` inside this function will generate an error
        echo "<p>Variable 'x' inside function is: $x</p>";
    } 
    myTest();
    
    echo "<p>Variable 'x' outside function is: $x</p>";
?>
```


#VSLIDE

### Global and Local Scopes

A variable declared **within** a function has a **local** scope and can only be accessed within that function:

```php
<?php
    function myTest() {
        $x = 5; // local scope
        echo "<p>Variable 'x' inside function is: $x</p>";
    } 
    myTest();
    
    // using `x` outside the function will generate an error
    echo "<p>Variable 'x' outside function is: $x</p>";
?>
```

_**Note:** You can have local variables with the same name in different functions, because local variables are only recognized by the function in which they are declared._


#VSLIDE

### `global` Keyword

The `global` keyword is used to access a global variable from within a function.

To do this, use the `global` keyword before the variables (inside the function).

```php
<?php
    $x = 5;
    $y = 10;
    
    function myTest() {
        global $x, $y;
        $y = $x + $y;
    }
    
    myTest();
    echo $y; // outputs 15
?>
```


#VSLIDE

_**Note:** PHP also stores all global variables in an array called `$GLOBALS[index]`. The `index` holds the name of the variable. This array is also accessible from within functions and can be used to update global variables directly._

```php
<?php
    $x = 5;
    $y = 10;
    
    function myTest() {
        $GLOBALS['y'] = $GLOBALS['x'] + $GLOBALS['y'];
    } 
    
    myTest();
    echo $y; // outputs 15
?>
```


#VSLIDE

### `static` Keyword

Normally, when a function is completed/executed, all of its variables are deleted.
To prevent variables from being deleted, the `static` keyword can be used.

```php
<?php
    function myTest() {
        static $x = 0;
        echo $x;
        $x++;
    }
    
    myTest();
    myTest();
    myTest();
?>
```

_**Note:** The variable is still local to the function._


#HSLIDE

## Echo / Print

`echo` and `print` are two basic ways to get output in PHP.


#VSLIDE

### Differences

* `echo` has no return value while print has a return value of `1`
* `echo` can take multiple parameters while `print` can take one argument
* `echo` is marginally faster than `print`


#VSLIDE

### `echo` text

```php
<?php
    echo "<h2>PHP is Fun!</h2>";
    echo "Hello world!<br>";
    echo "I'm about to learn PHP!<br>";
    echo "This ", "string ", "was ", "made ", "with multiple parameters.";
?>
```


#VSLIDE

### `echo` variables

```php
<?php
    $txt1 = "Learn PHP";
    $txt2 = "WDC";
    $x = 5;
    $y = 4;
    
    echo "<h2>$txt1</h2>";
    echo "Study PHP at $txt2<br>";
    echo $x + $y;
?>
```


#VSLIDE

### `print` text

```php
<?php
    print "<h2>PHP is Fun!</h2>";
    print "Hello world!<br>";
    print "I'm about to learn PHP!";
?>
```


#VSLIDE

### `print` variables

```php
<?php
    $txt1 = "Learn PHP";
    $txt2 = "WDC";
    $x = 5;
    $y = 4;
    
    print "<h2>$txt1</h2>";
    print "Study PHP at $txt2<br>";
    print $x + $y;
?>
```


#HSLIDE

## Data Types

* `String`
* `Integer`
* `Float` (floating point numbers - also called double)
* `Boolean`
* `Array`
* `Object`
* `NULL`
* `Resource`


#VSLIDE

### `String`

A string is a sequence of characters. A string can be any text inside quotes.

Single or double quotes can be used.

```php
<?php 
    $x = "Hello world!";
    $y = 'Hello world!';
    
    echo $x;
    echo "<br>"; 
    echo $y;
?>
```


#VSLIDE

### `Integer`

An integer data type is a non-decimal number between -2,147,483,648 and 2,147,483,647.

Rules for integers:
* An integer must have at least one digit
* An integer must **not** have a decimal point
* An integer can be either positive or negative
* Integers can be specified in three formats:
  * decimal (10-based)
  * hexadecimal (16-based - prefixed with `0x`)
  * octal (8-based - prefixed with `0`)

```php
<?php 
    $x = 5985;
    var_dump($x);
?>
```


#VSLIDE

### `Float`

A float (floating point number) is a number with a decimal point or a number in exponential form.

```php
<?php 
    $x = 10.365;
    var_dump($x);
?>
```


#VSLIDE

### Boolean

A Boolean represents two possible states: `TRUE` or `FALSE`.

```php
<?php
    $x = true;
    $y = false;
    var_dump($x);
    var_dump($y);
?>
```


#VSLIDE

### Array

An array stores multiple values in one single variable.

```php
<?php 
    $cars = array("Volvo", "BMW", "Toyota");
    var_dump($cars);
?>
```


#VSLIDE

### Object

An object is a data type which stores data and information on how to process that data.

In PHP, an object must be explicitly declared.

First we must declare a class of object. For this, we use the `class` keyword.
A class is a structure that can contain properties and methods.

```php
<?php
    class Car {
        function Car() {
            $this->model = "BMW";
        }
    }
    
    // create an object
    $z4 = new Car();
    
    // show object properties
    echo $z4->model;
?>
```


#VSLIDE

### NULL

Null is a special data type which can have only one value: `NULL`.

A variable of data type `NULL` is a variable that has no value assigned to it.

_**Note:** If a variable is created without a value, it is automatically assigned a value of `NULL`._

Variables can also be emptied by setting the value to `NULL`.

```php
<?php
    $x = "Hello world!";
    $x = null;
    var_dump($x);
?>
```


#VSLIDE

### Resource

The special resource type is not an actual data type.
It is the storing of a reference to functions and resources external to PHP.

A common example of using the resource data type is a database call.


#HSLIDE

## Constants

A constant is an identifier (name) for a simple value. The value **cannot** be changed during the script.

A valid constant name starts with a letter or underscore (no $ sign before the constant name).

_**Note:** Unlike variables, constants are automatically global across the entire script._


#VSLIDE

### Create a PHP Constant

To create a constant, use the `define()` function.

#### Syntax
`define(name, value, case-insensitive)`
Parameters:
* `name`: Specifies the name of the constant
* `value`: Specifies the value of the constant
* `case-insensitive`: Specifies whether the constant name should be case-insensitive. Default is false

```php
<?php
    define("GREETING", "Welcome to WDC!");
    echo GREETING;
?>
```

```php
<?php
    define("GREETING", "Welcome to W3Schools.com!", true);
    echo greeting;
?>
```


## Constants are Global

Constants are automatically global and can be used across the entire script.

```php
<?php
    define("GREETING", "Welcome to WDC!");
    
    function myTest() {
        echo GREETING;
    }
     
    myTest();
?>
```


#HSLIDE

## String functions


#VSLIDE

### Length of a String

The PHP `strlen()` function returns the length of a string.

```php
<?php
    echo strlen("Hello world!"); // outputs 12
?>
```


#VSLIDE

### Number of Words in a String

The PHP `str_word_count()` function counts the number of words in a string

```php
<?php
    echo str_word_count("Hello world!"); // outputs 2
?>
```


#VSLIDE

### Reverse a String

The PHP `strrev()` function reverses a string.

```php
<?php
    echo strrev("Hello world!"); // outputs !dlrow olleH
?>
```


#VSLIDE

### Search For a Specific Text Within a String

The PHP `strpos()` function searches for a specific text within a string.

If a match is found, the function returns the character position of the first match.
If no match is found, it will return `FALSE`.

```php
<?php
    echo strpos("Hello world!", "world"); // outputs 6
?>
```

_**Note:** The first character position in a string is `0` (not `1`)._


#VSLIDE

### Replace Text Within a String

The PHP `str_replace()` function replaces some characters with some other characters in a string.

```php
<?php
    echo str_replace("world", "Dolly", "Hello world!"); // outputs Hello Dolly!
?>
```


#HSLIDE

## Operators

Operators are used to perform operations on variables and values.

PHP divides the operators in the following groups:
* Arithmetic operators
* Assignment operators
* Comparison operators
* Increment/Decrement operators
* Logical operators
* String operators
* Array operators


#VSLIDE

### Arithmetic Operators

|Operator|Name
|--------|----
| `+`  | Addition
| `-`  | Subtraction
| `*`  | Multiplication
| `/`  | Division
| `%`  | Modulus
| `**` | Exponentiation


#VSLIDE

### Assignment Operators

The basic assignment operator in PHP is "`=`".

|Assignment|Same as...
|----------|----------
| `x = y`  | `x = y`
| `x += y` | `x = x + y`
| `x -= y` | `x = x - y`
| `x *= y` | `x = x * y`
| `x /= y` | `x = x / y`
| `x %= y` | `x = x % y`


#VSLIDE

### Comparison Operators

|Operator|Name
|--------|----
| `==`  | Equal
| `===` | Identical
| `!=`  | Not equal
| `<>`  | Not equal
| `!==` | Not identical
| `>`   | Greater than
| `<`   | Less than
| `>=`  | Greater than or equal to
| `<=`  | Less than or equal to


#VSLIDE

### Increment / Decrement Operators

|Operator|Name
|--------|----
| `++$x` | Pre-increment
| `$x++` | Post-increment
| `--$x` | Pre-decrement
| `$x--` | Post-decrement


#VSLIDE

### Logical Operators

|Operator|Name
|--------|----
| `and` | And
| `or`  | Or
| `xor` | Xor
| `&&`  | And
| `||`  | Or
| `!`   | Not


#VSLIDE

### String Operators

PHP has two operators that are specially designed for strings.

|Operator|Name
|--------|----
| `.`  | Concatenation
| `.=` | Concatenation assignment


#VSLIDE

### Array Operators

The PHP array operators are used to compare arrays.

|Operator|Name
|--------|----
| `+`   | Union
| `==`  | Equality
| `===` | Identity
| `!=`  | Inequality
| `<>`  | Inequality
| `!==` | Non-identity


#HSLIDE

## References

* [W3Schools](http://www.w3schools.com/php)
