-- Drop table

DROP TABLE IF EXISTS Messages;

-- Create table

CREATE TABLE IF NOT EXISTS Messages (
	id       INT      PRIMARY KEY AUTO_INCREMENT,
	date     DATETIME NOT NULL,
	username TINYTEXT NOT NULL,
	message  TEXT     NOT NULL
);

-- Store message

INSERT INTO Messages (date, username, message)
	VALUES (NOW(), ?, ?);

-- Get last 50 messages

SELECT
	id, date, username, message
FROM
	Messages
LIMIT 50;

-- Get id of the last message

SELECT
	MAX(id) AS max_id
FROM
	Messages;
