angular.module('chatroom', [])
    .controller('ChatRoomController', ['$scope', '$http', '$interval', function ($scope, $http, $interval) {
        $scope.newMessage = {};

        $scope.messages = [];
        $scope.maxMessageId = 0;

        $scope.checkNewMessages = function () {
            $http.get('messages.php?id')
                .success(function (id) {
                    if (id > $scope.maxMessageId) {
                        $scope.loadMessages();
                    }
                });
        };

        $scope.loadMessages = function () {
            $http.get('messages.php')
                .success(function (messages) {
                    $scope.messages = messages;
                    $scope.maxMessageId = Math.max.apply(Math, $scope.messages.map(function(m){return m.id}));
                });

            $_body = $('body');
            $_body.stop().animate({
                scrollTop: $_body[0].scrollHeight
            }, 400);
        };

        $scope.sendMessage = function () {
            $http.post('messages.php', $scope.newMessage)
                .success(function () {
                    $scope.newMessage = {};
                });
        };

        // Init

        $scope.loadMessages();

        $interval(function () {
            $scope.checkNewMessages();
        }, 1000);
    }]);