<?php

$con = mysqli_connect('localhost', 'chatroom', 'chatroom', 'chatroom');

if (mysqli_connect_errno()) die;

switch ($_SERVER['REQUEST_METHOD']) {
	case 'GET':
		// messages.php?id
		if (isset($_GET['id'])) {
			$result = mysqli_query($con, 'SELECT MAX(id) AS max_id FROM Messages');
			echo mysqli_fetch_array($result)['max_id'];

			die;
		}

		// messages.php?last=50
		$limit = isset($_GET['last']) ? $_GET['last'] : 50;
		$st = mysqli_prepare($con, 'SELECT id, date, username, message FROM Messages LIMIT ?');
		$st->bind_param('i',  $limit);
		$st->execute();
		$result = $st->get_result();

		$messages = [];
		while ($row = mysqli_fetch_assoc($result)) {
			$message['id']      = $row['id'];
			$message['date']    = $row['date'];
			$message['name']    = $row['username'];
			$message['message'] = $row['message'];

			$messages[] = $message;
		}

		print_r(json_encode($messages));

		break;
	case 'POST':
		$message = json_decode(file_get_contents('php://input'));

		$name = $message->name;
		$mess = $message->message;

		$st = mysqli_prepare($con, 'INSERT INTO Messages (date, username, message) VALUES (NOW(), ?, ?)');
		$st->bind_param('ss', $name, $mess);
		$result = $st->execute();

		break;
}

mysqli_close($con);
