<?php

define('PATH_TO_XML', __DIR__ . '/users.xml');

function authenticateUser($login, $password) {
	$users = simplexml_load_file(PATH_TO_XML);

	foreach ($users as $user) {
		if ($user->login == $login) {
			return password_verify($password, $user->password);
		}
	}

	return false;
}

function addUser($login, $password) {
	$password = password_hash($password, PASSWORD_DEFAULT);

	$users = simplexml_load_file(PATH_TO_XML);

	if (!$users->count()) {
		$userWillBeAdmin = true;
	}
	$user = $users->addChild('user');
	if (!empty($userWillBeAdmin)) {
		$user->addAttribute('rights', 'admin');
    }
	$user->addChild('login', $login);
	$user->addChild('password', $password);

	$users->asXML(PATH_TO_XML);
}

function usersNumber() {
	return simplexml_load_file(PATH_TO_XML)->count();
}

function hasAdminRights($login) {
	$users = simplexml_load_file(PATH_TO_XML);

	foreach ($users as $user) {
		if ($user->login == $login) {
			$rights = $user->attributes()['rights'];
			$rights = explode(',', $rights);
			foreach ($rights as $right) {
				if (trim($right) == 'admin') return true;
			}
		}
	}

	return false;
}
