This repository just contains an [original Sentry setup instructions](https://hub.docker.com/_/sentry/) but with using of Docker Compose

# Sentry

Sentry is a realtime, platform-agnostic error logging and aggregation platform

## What is Sentry?

Sentry is a realtime event logging and aggregation platform. It specializes in monitoring errors and extracting all the information needed to do a proper post-mortem without any of the hassle of the standard user feedback loop.

## How to setup a full Sentry instance

1. Specify your DB and SMTP server credentials in `.env` file

2. Generate a new secret key to be shared by all `sentry` containers. This value will then be used as the SENTRY_SECRET_KEY environment variable.
    ``` bash
    docker-compose run --rm sentry config generate-secret-key
    ```

3. Insert generated secret key into `.env` file

4. If this is a new database, you'll need to run `upgrade`
    ``` bash
    docker-compose run --rm sentry upgrade
    ```

5. Now start up Sentry server
    ``` bash
    docker-compose up -d sentry
    ```

6. The default config needs a celery beat and celery workers, start as many workers as you need (each with a unique name)
    ``` bash
    docker-compose up -d cron
    docker-compose up -d worker
    ```
