#!/bin/bash
set -e

if ! [ -e $PWD/app/nut -a -e $PWD/public/index.php ]; then
	echo >&2 "Bolt not found in $PWD. Installing now..."

	if [ "$(ls -A)" ]; then
		echo >&2 "WARNING: $PWD is not empty! Press Ctrl+C now if this is an error!"
		(set -x; ls -A; sleep 10)
	fi

	tar cplC /usr/src/bolt . | tar xplC $PWD

	php app/nut init

	set +e
	chown -R www-data:www-data .
	chmod a+r .
	for dir in app/cache/ app/database/ public/thumbs/
	do
		find $dir -type d -print0 | xargs -0 chmod u+rwx,g+rwxs,o+rx-w
		find $dir -type f -print0 | xargs -0 chmod u+rw-x,g+rw-x,o+r-wx > /dev/null 2>&1
	done
	for dir in app/config/ extensions/ public/extensions/ public/files/ public/theme/
	do
		find $dir -type d -print0 | xargs -0 chmod u+rwx,g+rwxs,o+rx-w
		find $dir -type f -print0 | xargs -0 chmod u+rw-x,g+rw-x,o+r-wx > /dev/null 2>&1
	done
	set -e
	echo >&2 "Finished. Bolt has been successfully installed into $PWD."
fi

docker-php-entrypoint apache2-foreground
